<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Country extends Model 
{

    protected $table = 'countries';
    public $timestamps = true;
    protected $fillable = array('name');

    public function agents()
    {
        return $this->hasMany('App\Models\Agent');
    }

    public function clients()
    {
        return $this->hasMany('App\Models\Client');
    }

    public function countryServices()
    {
        return $this->hasMany('App\Models\CountryService');
    }

}